### Text-Markierer-Tool für Webseiten

Dieses Tool ist ein schlanker, in den Browser integrierter Textmarker, mit dem Nutzer Text direkt auf Ihrer Webseite hervorheben können. Die Markierungen werden lokal im Browser des Nutzers gespeichert und bleiben auch nach dem Schließen der Seite erhalten. Da es keine externen Bibliotheken oder Serververbindungen benötigt, ist es sehr einfach zu implementieren und äußerst leistungsstark.

-----

### Was das Tool kann

  * **Text hervorheben**: Besucher können Textpassagen mit ihrer Maus markieren und per Klick eine Farbe aus einer Palette auswählen, um sie dauerhaft hervorzuheben.
  * **Dauerhafte Speicherung**: Die Markierungen werden im `localStorage` des Browsers gesichert. Sie sind seitenübergreifend und bleiben erhalten, selbst wenn der Browser geschlossen und die Seite erneut geöffnet wird.
  * **Farbauswahl**: Eine anpassbare Farbpalette bietet verschiedene Optionen für die Markierungsfarbe.
  * **Seiten-spezifische Markierungen**: Jede Markierung ist einzigartig für die Seite, auf der sie erstellt wurde. Es gibt keine Verwechslungen oder falsche Platzierungen zwischen verschiedenen Unterseiten Ihrer Website.
  * **Keine externen Abhängigkeiten**: Das gesamte Tool besteht aus reinem **HTML**, **CSS** und **JavaScript**. Es wird keine externe Bibliothek wie jQuery oder ein Backend-System benötigt.
  * **Einfache Löschfunktion**: Markierungen können durch einen einfachen Klick auf die markierte Stelle wieder entfernt werden.

-----

### Die Technik dahinter

Das Tool nutzt Standard-Webtechnologien, um seine Funktionalität zu erreichen. Es ist in drei Hauptbereiche unterteilt:

#### 1\. HTML (Die Benutzeroberfläche)

Die Benutzeroberfläche besteht aus einem versteckten modalen Fenster (`#colorModal`), das erscheint, wenn ein Text markiert wird. Es enthält die Farbfelder (`color-swatch`), die die Farbpalette darstellen, sowie die Schaltflächen zum Löschen und Schließen. Der eigentliche Text der Webseite befindet sich in einem Container (`.content_container`), damit das Skript genau weiß, in welchem Bereich es nach Markierungen suchen soll.

#### 2\. CSS (Das Aussehen)

Das CSS sorgt für das visuelle Design des Tools. Es steuert die Position und das Aussehen des modalen Fensters und der Farbfelder. Am wichtigsten ist jedoch die Formatierung der markierten Textstellen.

```css
.highlight {
    padding: 5px;
    font-weight: 700;
}
```

Die Klasse `.highlight` wird den markierten `<span>`-Elementen zugewiesen. Die Eigenschaft `padding` erzeugt einen kleinen Abstand um den Text, während `font-weight: 700` den Text fett macht, um die Lesbarkeit zu verbessern. Die Hintergrundfarbe wird dynamisch per JavaScript gesetzt.

#### 3\. JavaScript (Die Logik)

Das Herzstück des Tools ist ein JavaScript-Skript, das alle Funktionen steuert.

  * **DOM-Manipulation**: Wenn ein Benutzer Text auswählt, wird mit `document.createRange()` und `range.surroundContents()` ein `<span>`-Element um den ausgewählten Text gelegt.
  * **Speicherung (`localStorage`)**: Das Skript speichert Markierungsdaten (Start- und Endposition, Farbe, Textinhalt) im **`localStorage`** des Browsers. Der Speicherort (`STORAGE_KEY`) wird dynamisch an die URL der jeweiligen Seite angepasst. Dadurch sind die Markierungen einer Seite immer von denen anderer Seiten getrennt, was das Problem mit den falschen Markierungen behebt.
  * **Funktionen**: Mehrere benutzerdefinierte Funktionen steuern den Prozess:
      * `getGlobalOffsets()`: Berechnet die Start- und Endposition des ausgewählten Textes, basierend auf dem gesamten Textinhalt des Containers.
      * `loadHighlights()` und `saveHighlights()`: Laden und speichern die Markierungsdaten im `localStorage`.
      * `renderAllHighlights()`: Baut die Markierungen beim Laden der Seite oder nach einer Änderung neu auf.

-----

Das ist eine wichtige und sehr hilfreiche Klarstellung. Die Tatsache, dass die Dateien zum Download bereitgestellt werden, ändert die Installationsanleitung grundlegend.

Hier ist eine neue, ausführliche Erklärung, die das berücksichtigt. Die Anleitung ist jetzt in zwei klare Abschnitte für PHP- und HTML-Nutzer unterteilt, basierend auf Ihrem bereitgestellten Workflow.

-----

### Installation und Verwendung

Die Installation des Text-Markierer-Tools ist sehr einfach, da die notwendigen Dateien bereits für den Download vorbereitet sind. Wählen Sie die Methode, die am besten zu Ihrer Webseite passt.

#### Die herunterzuladenden Dateien:

  * `marker_tool.html` (enthält den HTML-Code für das Modal-Fenster und das CSS)
  * `marker_tool.js` (enthält die gesamte JavaScript-Logik)

-----

#### Methode 1: Für PHP-Webseiten (Empfohlen)

Dies ist die schnellste und sauberste Methode. Sie müssen keinen Code kopieren und einfügen.

1.  **Dateien hochladen**: Laden Sie die beiden Dateien (`marker_tool.html` und `marker_tool.js`) in das gleiche Verzeichnis hoch, in dem sich Ihre PHP-Datei befindet.
2.  **Code einfügen**: Fügen Sie die folgende Zeile in jede Ihrer PHP-Dateien ein, auf der der Textmarker verfügbar sein soll. Platzieren Sie sie idealerweise direkt vor dem schließenden `</body>`-Tag. Die `marker_tool.html` Datei lädt die JavaScript-Datei automatisch.

<!-- end list -->

```html
...
<?php include('marker_tool.html'); ?>
</body>
</html>
```

*Wichtiger Hinweis:* Stellen Sie sicher, dass der gesamte Textinhalt, den Sie markieren möchten, in ein Element mit der Klasse `.content_container` eingeschlossen ist, z. B. `<main class="content_container">...</main>`.

Sehr gut. Eine Erklärung, wie man den Content-Container anpasst, ist eine sehr nützliche Ergänzung für die README. Sie können diese Beschreibung direkt unter dem "Wichtiger Hinweis"-Abschnitt einfügen.

-----

### Anpassung des Content-Containers

Das Tool ist standardmäßig auf die Klasse `.content_container` eingestellt. Wenn Sie einen anderen Selektor (z.B. eine andere Klasse oder eine ID) für Ihren Inhaltsbereich verwenden möchten, müssen Sie nur eine einzige Zeile im JavaScript-Code anpassen.

Suchen Sie in der Datei **`marker_tool.js`** nach der folgenden Zeile:

```javascript
const content = document.querySelector('.content_container');
```

Ändern Sie den Selektor **`.content_container`** innerhalb der Anführungszeichen.

  * Wenn Ihr Container die Klasse **`mein-text`** hat, ändern Sie die Zeile zu:
    `const content = document.querySelector('.mein-text');`
  * Wenn Ihr Container die ID **`mein-inhalt`** hat, ändern Sie die Zeile zu:
    `const content = document.querySelector('#mein-inhalt');`

Nachdem Sie diese eine Zeile geändert haben, funktioniert das gesamte Tool automatisch mit Ihrem neuen Container.
-----

#### Methode 2: Für reine HTML-Webseiten

Diese Methode ist für Websites ohne PHP-Unterstützung. Hier müssen Sie den Code manuell kopieren und in jede Seite einfügen.

1.  **Dateien öffnen**: Öffnen Sie die heruntergeladenen Dateien (`marker_tool.html` und `marker_tool.js`) in einem Texteditor.
2.  **Code kopieren und einfügen**: Kopieren Sie den Code aus jeder Datei und fügen Sie ihn wie folgt in Ihre HTML-Datei ein:
      * **HTML & CSS**: Kopieren Sie den gesamten Inhalt aus `marker_tool.html` und fügen Sie ihn am Ende Ihres `<body>`-Tags ein. Die Datei enthält sowohl das HTML für das Modal als auch das CSS im `<style>`-Tag.
      * **JavaScript**: Kopieren Sie den gesamten Code aus `marker_tool.js` und fügen Sie ihn in ein `<script>`-Tag ein, das direkt nach dem HTML-Code des Modals steht.
3.  **Beispiel-Struktur**: Ihre endgültige HTML-Seite sollte so aufgebaut sein:

<!-- end list -->

```html
<!DOCTYPE html>
<html>
<head>
    </head>
<body>
    <main class="content_container">
        <h1>Mein Seiten-Titel</h1>
        <p>Hier ist ein Absatz Text.</p>
    </main>

    <div id="colorModal" ...>
        <style>
            /* CSS hier */
        </style>
        ...
    </div>

    <script>
        // JS hier
    </script>
</body>
</html>
```

*Wichtiger Hinweis:* Auch bei dieser Methode muss der gesamte Textinhalt, der markiert werden soll, in ein Element mit der Klasse `.content_container` eingeschlossen sein.