/*
## License
This tool is provided under the MIT License.

You are permitted to:
- freely use, copy, and distribute the script,
- use it for private and commercial projects,
- modify it and create your own versions.

Conditions:
- In all copies or substantial portions of the script, the above copyright notice 
  and this permission notice must be included.
- No warranty or guarantee of any kind is provided. Use at your own risk.

Disclaimer:
This tool is provided "as is", without warranty of any kind.  
The full responsibility for its use lies solely with the user.
*/

        function encodeText() {
    let input = document.getElementById('input').value;
    let output = input.split('\n').map(line => {
        return line.split('').map(char => {
            if (char === '<' || char === '>' || char === '/') return char;
            return '&#' + char.charCodeAt(0) + ';';
        }).join('');
    }).join('<br>');
    output = '<p>' + output + '</p>';
    document.getElementById('output').textContent = output;
}


        function copyToClipboard() {
  let output = document.getElementById('output');
  navigator.clipboard.writeText(output.textContent).then(() => {
    showMessage('Text copied!');
  }).catch(err => {
    console.error('Error while copying: ', err);
  });
}

function showMessage(message) {
  let messageContainer = document.getElementById('message-container');
  messageContainer.textContent = message;
  messageContainer.classList.remove('message-hidden');
  messageContainer.classList.add('message-visible');

  setTimeout(() => {
    messageContainer.classList.remove('message-visible');
    messageContainer.classList.add('message-hidden');
  }, 6000);
}

function setupAccordion(accordionId) {
        const accordion = document.getElementById(accordionId);
        accordion.addEventListener('click', function(e) {
            if (e.target.classList.contains('accordion_title')) {
                const content = e.target.nextElementSibling;
                const isActive = e.target.classList.contains('active');
                
                this.querySelectorAll('.accordion_title').forEach(title => {
                    title.classList.remove('active');
                    title.nextElementSibling.classList.remove('active');
                });

                if (!isActive) {
                    e.target.classList.add('active');
                    content.classList.add('active');
                }
            }
        });
    }

    setupAccordion('accordion_1');
	
	function resetPage() {
    location.reload();
}