<!--
## License
This tool is provided under the MIT License.

You are permitted to:
- freely use, copy, and distribute the script,
- use it for private and commercial projects,
- modify it and create your own versions.

Conditions:
- In all copies or substantial portions of the script, the above copyright notice 
  and this permission notice must be included.
- No warranty or guarantee of any kind is provided. Use at your own risk.

Disclaimer:
This tool is provided "as is", without warranty of any kind.  
The full responsibility for its use lies solely with the user.
-->

<!DOCTYPE html>
<html lang="en">
<head>
	<link rel="shortcut icon" media="all" href="https://webtools.whitefox-webdesign.de/favicon.png" type="image/x-icon">
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="language" content="en">
<link rel="stylesheet" href="style.css">
    <title>Unicode Crypt</title>
</head>
<body>
    <div class="container">
        <div class="input-section">
            <textarea id="input" placeholder="Enter your text here..."></textarea><br>
            <button class="encodeText" onclick="encodeText()">Encrypt</button>
            <button class="copyToClipboard" onclick="copyToClipboard()">Copy</button>
			<button class="resetPage" onclick="resetPage()">Reset</button>
        </div>
        <div class="output-section">
            <div id="output"></div>
			
<div class="accordion" id="accordion_1">
	<div class="accordion_title">Instructions for using the Unicode Encryption Tool</div>
		<div class="accordion_content">
			<h3>Text input:</h3> 
            <ul> 
              <li>Simply enter your text in the text field.</li> 
              <li>You do not need to manually insert HTML tags such as &lt;p&gt; or &lt;br&gt;.</li> 
            </ul> 
            <h3>Line breaks:</h3> 
            <ul> 
              <li>For a single line break, press the Enter key once.</li> 
              <li>For a paragraph (double line break), leave one blank line between text sections.</li> 
            </ul> 
            <h3>Automatic formatting:</h3> 
            <ul> 
              <li>The tool automatically adds &lt;p&gt; tags at the beginning and end of the text.</li> 
              <li>Single line breaks are converted into &lt;br&gt; tags.</li> 
              <li>Double line breaks (blank lines) are converted into two &lt;br&gt; tags.</li> 
            </ul> 
            <h3>Encryption:</h3> 
            <ul> 
              <li>Click "Encrypt" to convert your text into Unicode entities.</li> 
              <li>All characters except &lt;, &gt; and / are encrypted.</li> 
            </ul> 
            <h3>Copy:</h3> 
            <ul> 
              <li>Use the "Copy" button to copy the encrypted text to the clipboard.</li> 
            </ul>           
		</div>
	<div class="accordion_title">Unicode Encryption Script: Protecting Sensitive Data</div>
		<div class="accordion_content">
			<div class="unicode_explanation">
              <p>This script is designed to protect email addresses and other sensitive text information on websites from automated spam bots and data harvesters. It works by converting each letter and character into its corresponding Unicode value.</p>
              <ul>
                <li>Makes it harder for bots to recognize email addresses</li>
                <li>Reduces the risk of spam and data theft</li>
                <li>Remains normally readable to human visitors</li>
                <li>Provides solid basic protection against most automated data harvesters</li>
                <li>Simple implementation without affecting user-friendliness</li>
                <li>Compatible with all modern web browsers</li>
              </ul> 
              <p>Although it does not provide absolute protection against advanced bots, this method represents an effective compromise between security and usability.</p>
            </div>          
		</div>
</div>
			<div id="message-container" class="message-hidden"></div>
		</div>
    </div>
	<script type="text/javascript" src="script.js"></script>
<footer class="footer_main">
    <div class="footer_content">
        <div class="footer_copyright">
            <span class="copyright_text">Copyright by</span> 
            <a class="copyright_url" href="https://webtools.whitefox-webdesign.de" target="_blank" rel="noopener">
                Whitefox-Webdesign.de
            </a> 
            <span class="copyright_year">2018 - <?php echo date("Y"); ?></span>
        </div>
    </div>
</footer>
</body>
</html>

