/*
## Lizenz
Dieses Tool wird unter der MIT-Lizenz bereitgestellt.  

Sie dürfen:
- das Skript frei verwenden, kopieren und weitergeben,
- es für private und kommerzielle Projekte einsetzen,
- Modifikationen vornehmen und eigene Versionen erstellen.

Bedingungen:
- In allen Kopien oder wesentlichen Teilen des Skripts muss der obige Copyright-Hinweis 
  sowie dieser Lizenztext enthalten bleiben.  
- Es wird keinerlei Haftung oder Garantie übernommen. Nutzung auf eigenes Risiko.

Haftungsausschluss:
Dieses Tool wird ohne jede Gewährleistung bereitgestellt. Die Nutzung erfolgt vollständig auf eigenes Risiko.
*/

        function encodeText() {
    let input = document.getElementById('input').value;
    let output = input.split('\n').map(line => {
        return line.split('').map(char => {
            if (char === '<' || char === '>' || char === '/') return char;
            return '&#' + char.charCodeAt(0) + ';';
        }).join('');
    }).join('<br>');
    output = '<p>' + output + '</p>';
    document.getElementById('output').textContent = output;
}


        function copyToClipboard() {
  let output = document.getElementById('output');
  navigator.clipboard.writeText(output.textContent).then(() => {
    showMessage('Text kopiert!');
  }).catch(err => {
    console.error('Fehler beim Kopieren: ', err);
  });
}

function showMessage(message) {
  let messageContainer = document.getElementById('message-container');
  messageContainer.textContent = message;
  messageContainer.classList.remove('message-hidden');
  messageContainer.classList.add('message-visible');

  setTimeout(() => {
    messageContainer.classList.remove('message-visible');
    messageContainer.classList.add('message-hidden');
  }, 6000);
}
	
	function resetPage() {
    location.reload();
}