## License

This tool is provided under the MIT License.  

You are permitted to:
- freely use, copy, and distribute the script,
- use it for private and commercial projects,
- modify it and create your own versions.

Conditions:
- In all copies or substantial portions of the script, the above copyright notice 
  and this permission notice must be included.
- No warranty or guarantee of any kind is provided. Use at your own risk.

Disclaimer:
This tool is provided "as is", without warranty of any kind.  
The full responsibility for its use lies solely with the user.

--------------------

# Unicode Encryption Script

## Description
This tool is designed to protect sensitive text information, especially email addresses, from automated spam bots and data harvesters.  
It converts every letter and character into its corresponding Unicode value.  
As a result, the text remains fully readable for human visitors, while bots have a harder time accessing the plain data.

## How It Works
- The entered text (e.g., an email address) is converted into Unicode references.
- The web browser renders these references and displays them as readable text.
- In the HTML source code, however, the data appears obfuscated, making it harder for simple bots to extract directly.

## Benefits
- Makes it more difficult for spam bots to detect and extract email addresses.
- Reduces the risk of spam and data theft.
- Easy to integrate into existing websites.
- No impact on user experience – the text remains readable.
- Compatible with all modern browsers.
- Requires no additional server or database resources.

## Limitations
- Not an absolute protection against very advanced crawlers or targeted attacks.
- The script is intended as a practical *basic protection* – an effective compromise between security and usability.

## Target Audience
- Website owners who need to publish contact information online but want to reduce spam.
- Developers looking for a straightforward method to obfuscate sensitive text data.
- Private users who need to make their information accessible online while keeping spam risk lower.

## Note
This tool is designed as a protective measure against the most common automated data harvesters.  
It does not replace additional security practices but serves as a useful complement.
